/*
 *  AsyncEvent.java
 *  SwingOSC
 *
 *  Copyright (c) 2005-2008 Hanns Holger Rutz. All rights reserved.
 *
 *	This software is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either
 *	version 2, june 1991 of the License, or (at your option) any later version.
 *
 *	This software is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License (gpl.txt) along with this software; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 *	For further information, please contact Hanns Holger Rutz at
 *	contact@sciss.de
 *
 *
 *  Changelog:
 */
package de.sciss.swingosc;

import de.sciss.app.BasicEvent;

public class AsyncEvent
extends BasicEvent
{
	public static final int	UPDATE		= 0;
	public static final int	FINISHED	= 1;
	public static final int	CANCELLED	= 2;
	public static final int	FAILED		= 3;

	public AsyncEvent( Object source, int id, long when )
	{
		super( source, id, when );
	}
	
	public boolean incorporate( BasicEvent oldEvent )
	{
		if( oldEvent instanceof AsyncEvent &&
			this.getSource() == oldEvent.getSource() &&
			this.getID() == oldEvent.getID() ) {
			
			return true;

		} else return false;
	}
}
